package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{PageSize, Marker}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDomainConfigurationsRequest(
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None,
    serviceType: Option[zio.aws.iot.model.ServiceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest = {
    import ListDomainConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListDomainConfigurationsRequest.ReadOnly =
    zio.aws.iot.model.ListDomainConfigurationsRequest.wrap(buildAwsValue())
}
object ListDomainConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListDomainConfigurationsRequest =
      zio.aws.iot.model.ListDomainConfigurationsRequest(
        marker.map(value => value),
        pageSize.map(value => value),
        serviceType.map(value => value)
      )
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def serviceType: Option[zio.aws.iot.model.ServiceType]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getServiceType: ZIO[Any, AwsError, zio.aws.iot.model.ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
  ) extends zio.aws.iot.model.ListDomainConfigurationsRequest.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val serviceType: Option[zio.aws.iot.model.ServiceType] = scala
      .Option(impl.serviceType())
      .map(value => zio.aws.iot.model.ServiceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest
  ): zio.aws.iot.model.ListDomainConfigurationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
