package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{QueryMaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListIndicesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[QueryMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListIndicesRequest = {
    import ListIndicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListIndicesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => QueryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListIndicesRequest.ReadOnly =
    zio.aws.iot.model.ListIndicesRequest.wrap(buildAwsValue())
}
object ListIndicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListIndicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListIndicesRequest =
      zio.aws.iot.model.ListIndicesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[QueryMaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, QueryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListIndicesRequest
  ) extends zio.aws.iot.model.ListIndicesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[QueryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.QueryMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListIndicesRequest
  ): zio.aws.iot.model.ListIndicesRequest.ReadOnly = new Wrapper(impl)
}
