package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, IndexName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListIndicesResponse(
    indexNames: Option[Iterable[IndexName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListIndicesResponse = {
    import ListIndicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListIndicesResponse
      .builder()
      .optionallyWith(
        indexNames.map(value =>
          value.map { item =>
            IndexName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.indexNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListIndicesResponse.ReadOnly =
    zio.aws.iot.model.ListIndicesResponse.wrap(buildAwsValue())
}
object ListIndicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListIndicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListIndicesResponse =
      zio.aws.iot.model.ListIndicesResponse(
        indexNames.map(value => value),
        nextToken.map(value => value)
      )
    def indexNames: Option[List[IndexName]]
    def nextToken: Option[NextToken]
    def getIndexNames: ZIO[Any, AwsError, List[IndexName]] =
      AwsError.unwrapOptionField("indexNames", indexNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListIndicesResponse
  ) extends zio.aws.iot.model.ListIndicesResponse.ReadOnly {
    override val indexNames: Option[List[IndexName]] = scala
      .Option(impl.indexNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.IndexName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListIndicesResponse
  ): zio.aws.iot.model.ListIndicesResponse.ReadOnly = new Wrapper(impl)
}
