package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, LaserMaxResults, JobId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListJobExecutionsForJobRequest(
    jobId: JobId,
    status: Option[zio.aws.iot.model.JobExecutionStatus] = None,
    maxResults: Option[LaserMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest = {
    import ListJobExecutionsForJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListJobExecutionsForJobRequest.ReadOnly =
    zio.aws.iot.model.ListJobExecutionsForJobRequest.wrap(buildAwsValue())
}
object ListJobExecutionsForJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListJobExecutionsForJobRequest =
      zio.aws.iot.model.ListJobExecutionsForJobRequest(
        jobId,
        status.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobId: JobId
    def status: Option[zio.aws.iot.model.JobExecutionStatus]
    def maxResults: Option[LaserMaxResults]
    def nextToken: Option[NextToken]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.JobExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
  ) extends zio.aws.iot.model.ListJobExecutionsForJobRequest.ReadOnly {
    override val jobId: JobId = zio.aws.iot.model.primitives.JobId(impl.jobId())
    override val status: Option[zio.aws.iot.model.JobExecutionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.JobExecutionStatus.wrap(value))
    override val maxResults: Option[LaserMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest
  ): zio.aws.iot.model.ListJobExecutionsForJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
