package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  NextToken,
  LaserMaxResults,
  ManagedJobTemplateName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListManagedJobTemplatesRequest(
    templateName: Option[ManagedJobTemplateName] = None,
    maxResults: Option[LaserMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest = {
    import ListManagedJobTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
      .builder()
      .optionallyWith(
        templateName.map(value =>
          ManagedJobTemplateName.unwrap(value): java.lang.String
        )
      )(_.templateName)
      .optionallyWith(
        maxResults.map(value => LaserMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListManagedJobTemplatesRequest.ReadOnly =
    zio.aws.iot.model.ListManagedJobTemplatesRequest.wrap(buildAwsValue())
}
object ListManagedJobTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListManagedJobTemplatesRequest =
      zio.aws.iot.model.ListManagedJobTemplatesRequest(
        templateName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def templateName: Option[ManagedJobTemplateName]
    def maxResults: Option[LaserMaxResults]
    def nextToken: Option[NextToken]
    def getTemplateName: ZIO[Any, AwsError, ManagedJobTemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getMaxResults: ZIO[Any, AwsError, LaserMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
  ) extends zio.aws.iot.model.ListManagedJobTemplatesRequest.ReadOnly {
    override val templateName: Option[ManagedJobTemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.ManagedJobTemplateName(value))
    override val maxResults: Option[LaserMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.LaserMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest
  ): zio.aws.iot.model.ListManagedJobTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
