package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListMitigationActionsRequest(
    actionType: Option[zio.aws.iot.model.MitigationActionType] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest = {
    import ListMitigationActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
      .builder()
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListMitigationActionsRequest.ReadOnly =
    zio.aws.iot.model.ListMitigationActionsRequest.wrap(buildAwsValue())
}
object ListMitigationActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListMitigationActionsRequest =
      zio.aws.iot.model.ListMitigationActionsRequest(
        actionType.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def actionType: Option[zio.aws.iot.model.MitigationActionType]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getActionType
        : ZIO[Any, AwsError, zio.aws.iot.model.MitigationActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
  ) extends zio.aws.iot.model.ListMitigationActionsRequest.ReadOnly {
    override val actionType: Option[zio.aws.iot.model.MitigationActionType] =
      scala
        .Option(impl.actionType())
        .map(value => zio.aws.iot.model.MitigationActionType.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest
  ): zio.aws.iot.model.ListMitigationActionsRequest.ReadOnly = new Wrapper(impl)
}
