package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, MaxResults}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListOtaUpdatesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest = {
    import ListOtaUpdatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(otaUpdateStatus.map(value => value.unwrap))(
        _.otaUpdateStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListOtaUpdatesRequest.ReadOnly =
    zio.aws.iot.model.ListOtaUpdatesRequest.wrap(buildAwsValue())
}
object ListOtaUpdatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListOtaUpdatesRequest =
      zio.aws.iot.model.ListOtaUpdatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        otaUpdateStatus.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOtaUpdateStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.OTAUpdateStatus] =
      AwsError.unwrapOptionField("otaUpdateStatus", otaUpdateStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
  ) extends zio.aws.iot.model.ListOtaUpdatesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val otaUpdateStatus: Option[zio.aws.iot.model.OTAUpdateStatus] =
      scala
        .Option(impl.otaUpdateStatus())
        .map(value => zio.aws.iot.model.OTAUpdateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest
  ): zio.aws.iot.model.ListOtaUpdatesRequest.ReadOnly = new Wrapper(impl)
}
