package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{AscendingOrder, PageSize, Marker}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPoliciesRequest(
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None,
    ascendingOrder: Option[AscendingOrder] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPoliciesRequest = {
    import ListPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPoliciesRequest
      .builder()
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .optionallyWith(
        ascendingOrder.map(value =>
          AscendingOrder.unwrap(value): java.lang.Boolean
        )
      )(_.ascendingOrder)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPoliciesRequest.ReadOnly =
    zio.aws.iot.model.ListPoliciesRequest.wrap(buildAwsValue())
}
object ListPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPoliciesRequest =
      zio.aws.iot.model.ListPoliciesRequest(
        marker.map(value => value),
        pageSize.map(value => value),
        ascendingOrder.map(value => value)
      )
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def ascendingOrder: Option[AscendingOrder]
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
    def getAscendingOrder: ZIO[Any, AwsError, AscendingOrder] =
      AwsError.unwrapOptionField("ascendingOrder", ascendingOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPoliciesRequest
  ) extends zio.aws.iot.model.ListPoliciesRequest.ReadOnly {
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.iot.model.primitives.Marker(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value => zio.aws.iot.model.primitives.PageSize(value))
    override val ascendingOrder: Option[AscendingOrder] = scala
      .Option(impl.ascendingOrder())
      .map(value => zio.aws.iot.model.primitives.AscendingOrder(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPoliciesRequest
  ): zio.aws.iot.model.ListPoliciesRequest.ReadOnly = new Wrapper(impl)
}
