package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, ThingName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListPrincipalThingsResponse(
    things: Option[Iterable[ThingName]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse = {
    import ListPrincipalThingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
      .builder()
      .optionallyWith(
        things.map(value =>
          value.map { item =>
            ThingName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.things)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly =
    zio.aws.iot.model.ListPrincipalThingsResponse.wrap(buildAwsValue())
}
object ListPrincipalThingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListPrincipalThingsResponse =
      zio.aws.iot.model.ListPrincipalThingsResponse(
        things.map(value => value),
        nextToken.map(value => value)
      )
    def things: Option[List[ThingName]]
    def nextToken: Option[NextToken]
    def getThings: ZIO[Any, AwsError, List[ThingName]] =
      AwsError.unwrapOptionField("things", things)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
  ) extends zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly {
    override val things: Option[List[ThingName]] = scala
      .Option(impl.things())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.ThingName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse
  ): zio.aws.iot.model.ListPrincipalThingsResponse.ReadOnly = new Wrapper(impl)
}
