package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  SecurityProfileTargetArn,
  Recursive,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSecurityProfilesForTargetRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    recursive: Option[Recursive] = None,
    securityProfileTargetArn: SecurityProfileTargetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest = {
    import ListSecurityProfilesForTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        recursive.map(value => Recursive.unwrap(value): java.lang.Boolean)
      )(_.recursive)
      .securityProfileTargetArn(
        SecurityProfileTargetArn.unwrap(
          securityProfileTargetArn
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListSecurityProfilesForTargetRequest.ReadOnly =
    zio.aws.iot.model.ListSecurityProfilesForTargetRequest.wrap(buildAwsValue())
}
object ListSecurityProfilesForTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListSecurityProfilesForTargetRequest =
      zio.aws.iot.model.ListSecurityProfilesForTargetRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        recursive.map(value => value),
        securityProfileTargetArn
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def recursive: Option[Recursive]
    def securityProfileTargetArn: SecurityProfileTargetArn
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getRecursive: ZIO[Any, AwsError, Recursive] =
      AwsError.unwrapOptionField("recursive", recursive)
    def getSecurityProfileTargetArn
        : ZIO[Any, Nothing, SecurityProfileTargetArn] =
      ZIO.succeed(securityProfileTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest
  ) extends zio.aws.iot.model.ListSecurityProfilesForTargetRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val recursive: Option[Recursive] = scala
      .Option(impl.recursive())
      .map(value => zio.aws.iot.model.primitives.Recursive(value))
    override val securityProfileTargetArn: SecurityProfileTargetArn =
      zio.aws.iot.model.primitives
        .SecurityProfileTargetArn(impl.securityProfileTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest
  ): zio.aws.iot.model.ListSecurityProfilesForTargetRequest.ReadOnly =
    new Wrapper(impl)
}
