package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  MetricName,
  DimensionName,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListSecurityProfilesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    dimensionName: Option[DimensionName] = None,
    metricName: Option[MetricName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest = {
    import ListSecurityProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        dimensionName.map(value =>
          DimensionName.unwrap(value): java.lang.String
        )
      )(_.dimensionName)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListSecurityProfilesRequest.ReadOnly =
    zio.aws.iot.model.ListSecurityProfilesRequest.wrap(buildAwsValue())
}
object ListSecurityProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListSecurityProfilesRequest =
      zio.aws.iot.model.ListSecurityProfilesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        dimensionName.map(value => value),
        metricName.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def dimensionName: Option[DimensionName]
    def metricName: Option[MetricName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDimensionName: ZIO[Any, AwsError, DimensionName] =
      AwsError.unwrapOptionField("dimensionName", dimensionName)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
  ) extends zio.aws.iot.model.ListSecurityProfilesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.MaxResults(value))
    override val dimensionName: Option[DimensionName] = scala
      .Option(impl.dimensionName())
      .map(value => zio.aws.iot.model.primitives.DimensionName(value))
    override val metricName: Option[MetricName] = scala
      .Option(impl.metricName())
      .map(value => zio.aws.iot.model.primitives.MetricName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest
  ): zio.aws.iot.model.ListSecurityProfilesRequest.ReadOnly = new Wrapper(impl)
}
