package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListStreamsResponse(
    streams: Option[Iterable[zio.aws.iot.model.StreamSummary]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListStreamsResponse = {
    import ListStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListStreamsResponse
      .builder()
      .optionallyWith(
        streams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streams)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListStreamsResponse.ReadOnly =
    zio.aws.iot.model.ListStreamsResponse.wrap(buildAwsValue())
}
object ListStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListStreamsResponse =
      zio.aws.iot.model.ListStreamsResponse(
        streams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def streams: Option[List[zio.aws.iot.model.StreamSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getStreams
        : ZIO[Any, AwsError, List[zio.aws.iot.model.StreamSummary.ReadOnly]] =
      AwsError.unwrapOptionField("streams", streams)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListStreamsResponse
  ) extends zio.aws.iot.model.ListStreamsResponse.ReadOnly {
    override val streams
        : Option[List[zio.aws.iot.model.StreamSummary.ReadOnly]] = scala
      .Option(impl.streams())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.StreamSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListStreamsResponse
  ): zio.aws.iot.model.ListStreamsResponse.ReadOnly = new Wrapper(impl)
}
