package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{RegistryMaxResults, NextToken, ThingName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingGroupsForThingRequest(
    thingName: ThingName,
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest = {
    import ListThingGroupsForThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest
      .builder()
      .thingName(ThingName.unwrap(thingName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingGroupsForThingRequest.ReadOnly =
    zio.aws.iot.model.ListThingGroupsForThingRequest.wrap(buildAwsValue())
}
object ListThingGroupsForThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingGroupsForThingRequest =
      zio.aws.iot.model.ListThingGroupsForThingRequest(
        thingName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def thingName: ThingName
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def getThingName: ZIO[Any, Nothing, ThingName] = ZIO.succeed(thingName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest
  ) extends zio.aws.iot.model.ListThingGroupsForThingRequest.ReadOnly {
    override val thingName: ThingName =
      zio.aws.iot.model.primitives.ThingName(impl.thingName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest
  ): zio.aws.iot.model.ListThingGroupsForThingRequest.ReadOnly = new Wrapper(
    impl
  )
}
