package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RecursiveWithoutDefault,
  ThingGroupName,
  RegistryMaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingGroupsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None,
    parentGroup: Option[ThingGroupName] = None,
    namePrefixFilter: Option[ThingGroupName] = None,
    recursive: Option[RecursiveWithoutDefault] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingGroupsRequest = {
    import ListThingGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        parentGroup.map(value => ThingGroupName.unwrap(value): java.lang.String)
      )(_.parentGroup)
      .optionallyWith(
        namePrefixFilter.map(value =>
          ThingGroupName.unwrap(value): java.lang.String
        )
      )(_.namePrefixFilter)
      .optionallyWith(
        recursive.map(value =>
          RecursiveWithoutDefault.unwrap(value): java.lang.Boolean
        )
      )(_.recursive)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingGroupsRequest.ReadOnly =
    zio.aws.iot.model.ListThingGroupsRequest.wrap(buildAwsValue())
}
object ListThingGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingGroupsRequest =
      zio.aws.iot.model.ListThingGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        parentGroup.map(value => value),
        namePrefixFilter.map(value => value),
        recursive.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def parentGroup: Option[ThingGroupName]
    def namePrefixFilter: Option[ThingGroupName]
    def recursive: Option[RecursiveWithoutDefault]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getParentGroup: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("parentGroup", parentGroup)
    def getNamePrefixFilter: ZIO[Any, AwsError, ThingGroupName] =
      AwsError.unwrapOptionField("namePrefixFilter", namePrefixFilter)
    def getRecursive: ZIO[Any, AwsError, RecursiveWithoutDefault] =
      AwsError.unwrapOptionField("recursive", recursive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
  ) extends zio.aws.iot.model.ListThingGroupsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val parentGroup: Option[ThingGroupName] = scala
      .Option(impl.parentGroup())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val namePrefixFilter: Option[ThingGroupName] = scala
      .Option(impl.namePrefixFilter())
      .map(value => zio.aws.iot.model.primitives.ThingGroupName(value))
    override val recursive: Option[RecursiveWithoutDefault] = scala
      .Option(impl.recursive())
      .map(value => zio.aws.iot.model.primitives.RecursiveWithoutDefault(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingGroupsRequest
  ): zio.aws.iot.model.ListThingGroupsRequest.ReadOnly = new Wrapper(impl)
}
