package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{RegistryMaxResults, NextToken, TaskId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingRegistrationTaskReportsRequest(
    taskId: TaskId,
    reportType: zio.aws.iot.model.ReportType,
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest = {
    import ListThingRegistrationTaskReportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .reportType(reportType.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListThingRegistrationTaskReportsRequest.ReadOnly =
    zio.aws.iot.model.ListThingRegistrationTaskReportsRequest
      .wrap(buildAwsValue())
}
object ListThingRegistrationTaskReportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingRegistrationTaskReportsRequest =
      zio.aws.iot.model.ListThingRegistrationTaskReportsRequest(
        taskId,
        reportType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def taskId: TaskId
    def reportType: zio.aws.iot.model.ReportType
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
    def getReportType: ZIO[Any, Nothing, zio.aws.iot.model.ReportType] =
      ZIO.succeed(reportType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest
  ) extends zio.aws.iot.model.ListThingRegistrationTaskReportsRequest.ReadOnly {
    override val taskId: TaskId =
      zio.aws.iot.model.primitives.TaskId(impl.taskId())
    override val reportType: zio.aws.iot.model.ReportType =
      zio.aws.iot.model.ReportType.wrap(impl.reportType())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest
  ): zio.aws.iot.model.ListThingRegistrationTaskReportsRequest.ReadOnly =
    new Wrapper(impl)
}
