package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, S3FileUrl}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingRegistrationTaskReportsResponse(
    resourceLinks: Option[Iterable[S3FileUrl]] = None,
    reportType: Option[zio.aws.iot.model.ReportType] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse = {
    import ListThingRegistrationTaskReportsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse
      .builder()
      .optionallyWith(
        resourceLinks.map(value =>
          value.map { item =>
            S3FileUrl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceLinks)
      .optionallyWith(reportType.map(value => value.unwrap))(_.reportType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly =
    zio.aws.iot.model.ListThingRegistrationTaskReportsResponse
      .wrap(buildAwsValue())
}
object ListThingRegistrationTaskReportsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingRegistrationTaskReportsResponse =
      zio.aws.iot.model.ListThingRegistrationTaskReportsResponse(
        resourceLinks.map(value => value),
        reportType.map(value => value),
        nextToken.map(value => value)
      )
    def resourceLinks: Option[List[S3FileUrl]]
    def reportType: Option[zio.aws.iot.model.ReportType]
    def nextToken: Option[NextToken]
    def getResourceLinks: ZIO[Any, AwsError, List[S3FileUrl]] =
      AwsError.unwrapOptionField("resourceLinks", resourceLinks)
    def getReportType: ZIO[Any, AwsError, zio.aws.iot.model.ReportType] =
      AwsError.unwrapOptionField("reportType", reportType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse
  ) extends zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly {
    override val resourceLinks: Option[List[S3FileUrl]] = scala
      .Option(impl.resourceLinks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.S3FileUrl(item)
        }.toList
      )
    override val reportType: Option[zio.aws.iot.model.ReportType] = scala
      .Option(impl.reportType())
      .map(value => zio.aws.iot.model.ReportType.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse
  ): zio.aws.iot.model.ListThingRegistrationTaskReportsResponse.ReadOnly =
    new Wrapper(impl)
}
