package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{RegistryMaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingRegistrationTasksRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None,
    status: Option[zio.aws.iot.model.Status] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest = {
    import ListThingRegistrationTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingRegistrationTasksRequest.ReadOnly =
    zio.aws.iot.model.ListThingRegistrationTasksRequest.wrap(buildAwsValue())
}
object ListThingRegistrationTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingRegistrationTasksRequest =
      zio.aws.iot.model.ListThingRegistrationTasksRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def status: Option[zio.aws.iot.model.Status]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
  ) extends zio.aws.iot.model.ListThingRegistrationTasksRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val status: Option[zio.aws.iot.model.Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest
  ): zio.aws.iot.model.ListThingRegistrationTasksRequest.ReadOnly = new Wrapper(
    impl
  )
}
