package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{NextToken, TaskId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingRegistrationTasksResponse(
    taskIds: Option[Iterable[TaskId]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse = {
    import ListThingRegistrationTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
      .builder()
      .optionallyWith(
        taskIds.map(value =>
          value.map { item =>
            TaskId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.taskIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly =
    zio.aws.iot.model.ListThingRegistrationTasksResponse.wrap(buildAwsValue())
}
object ListThingRegistrationTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingRegistrationTasksResponse =
      zio.aws.iot.model.ListThingRegistrationTasksResponse(
        taskIds.map(value => value),
        nextToken.map(value => value)
      )
    def taskIds: Option[List[TaskId]]
    def nextToken: Option[NextToken]
    def getTaskIds: ZIO[Any, AwsError, List[TaskId]] =
      AwsError.unwrapOptionField("taskIds", taskIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
  ) extends zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly {
    override val taskIds: Option[List[TaskId]] = scala
      .Option(impl.taskIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.TaskId(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse
  ): zio.aws.iot.model.ListThingRegistrationTasksResponse.ReadOnly =
    new Wrapper(impl)
}
