package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingTypeName,
  RegistryMaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListThingTypesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[RegistryMaxResults] = None,
    thingTypeName: Option[ThingTypeName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListThingTypesRequest = {
    import ListThingTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListThingTypesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => RegistryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListThingTypesRequest.ReadOnly =
    zio.aws.iot.model.ListThingTypesRequest.wrap(buildAwsValue())
}
object ListThingTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListThingTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListThingTypesRequest =
      zio.aws.iot.model.ListThingTypesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        thingTypeName.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[RegistryMaxResults]
    def thingTypeName: Option[ThingTypeName]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, RegistryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListThingTypesRequest
  ) extends zio.aws.iot.model.ListThingTypesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[RegistryMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.RegistryMaxResults(value))
    override val thingTypeName: Option[ThingTypeName] = scala
      .Option(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListThingTypesRequest
  ): zio.aws.iot.model.ListThingTypesRequest.ReadOnly = new Wrapper(impl)
}
