package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTopicRuleDestinationsResponse(
    destinationSummaries: Option[
      Iterable[zio.aws.iot.model.TopicRuleDestinationSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse = {
    import ListTopicRuleDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
      .builder()
      .optionallyWith(
        destinationSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly =
    zio.aws.iot.model.ListTopicRuleDestinationsResponse.wrap(buildAwsValue())
}
object ListTopicRuleDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListTopicRuleDestinationsResponse =
      zio.aws.iot.model.ListTopicRuleDestinationsResponse(
        destinationSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def destinationSummaries
        : Option[List[zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDestinationSummaries: ZIO[Any, AwsError, List[
      zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("destinationSummaries", destinationSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
  ) extends zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly {
    override val destinationSummaries
        : Option[List[zio.aws.iot.model.TopicRuleDestinationSummary.ReadOnly]] =
      scala
        .Option(impl.destinationSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.TopicRuleDestinationSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse
  ): zio.aws.iot.model.ListTopicRuleDestinationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
