package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{SkyfallMaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListV2LoggingLevelsRequest(
    targetType: Option[zio.aws.iot.model.LogTargetType] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[SkyfallMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest = {
    import ListV2LoggingLevelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
      .builder()
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => SkyfallMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ListV2LoggingLevelsRequest.ReadOnly =
    zio.aws.iot.model.ListV2LoggingLevelsRequest.wrap(buildAwsValue())
}
object ListV2LoggingLevelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ListV2LoggingLevelsRequest =
      zio.aws.iot.model.ListV2LoggingLevelsRequest(
        targetType.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def targetType: Option[zio.aws.iot.model.LogTargetType]
    def nextToken: Option[NextToken]
    def maxResults: Option[SkyfallMaxResults]
    def getTargetType: ZIO[Any, AwsError, zio.aws.iot.model.LogTargetType] =
      AwsError.unwrapOptionField("targetType", targetType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, SkyfallMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
  ) extends zio.aws.iot.model.ListV2LoggingLevelsRequest.ReadOnly {
    override val targetType: Option[zio.aws.iot.model.LogTargetType] = scala
      .Option(impl.targetType())
      .map(value => zio.aws.iot.model.LogTargetType.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Option[SkyfallMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.SkyfallMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest
  ): zio.aws.iot.model.ListV2LoggingLevelsRequest.ReadOnly = new Wrapper(impl)
}
