package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MachineLearningDetectionConfig(
    confidenceLevel: zio.aws.iot.model.ConfidenceLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.MachineLearningDetectionConfig = {
    import MachineLearningDetectionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MachineLearningDetectionConfig
      .builder()
      .confidenceLevel(confidenceLevel.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly =
    zio.aws.iot.model.MachineLearningDetectionConfig.wrap(buildAwsValue())
}
object MachineLearningDetectionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.MachineLearningDetectionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MachineLearningDetectionConfig =
      zio.aws.iot.model.MachineLearningDetectionConfig(confidenceLevel)
    def confidenceLevel: zio.aws.iot.model.ConfidenceLevel
    def getConfidenceLevel
        : ZIO[Any, Nothing, zio.aws.iot.model.ConfidenceLevel] =
      ZIO.succeed(confidenceLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MachineLearningDetectionConfig
  ) extends zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly {
    override val confidenceLevel: zio.aws.iot.model.ConfidenceLevel =
      zio.aws.iot.model.ConfidenceLevel.wrap(impl.confidenceLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MachineLearningDetectionConfig
  ): zio.aws.iot.model.MachineLearningDetectionConfig.ReadOnly = new Wrapper(
    impl
  )
}
