package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{MqttClientId, MqttPassword, MqttUsername}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MqttContext(
    username: Option[MqttUsername] = None,
    password: Option[MqttPassword] = None,
    clientId: Option[MqttClientId] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.MqttContext = {
    import MqttContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.MqttContext
      .builder()
      .optionallyWith(
        username.map(value => MqttUsername.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        password.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.password)
      .optionallyWith(
        clientId.map(value => MqttClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.MqttContext.ReadOnly =
    zio.aws.iot.model.MqttContext.wrap(buildAwsValue())
}
object MqttContext {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.MqttContext] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.MqttContext =
      zio.aws.iot.model.MqttContext(
        username.map(value => value),
        password.map(value => value),
        clientId.map(value => value)
      )
    def username: Option[MqttUsername]
    def password: Option[MqttPassword]
    def clientId: Option[MqttClientId]
    def getUsername: ZIO[Any, AwsError, MqttUsername] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, MqttPassword] =
      AwsError.unwrapOptionField("password", password)
    def getClientId: ZIO[Any, AwsError, MqttClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.MqttContext
  ) extends zio.aws.iot.model.MqttContext.ReadOnly {
    override val username: Option[MqttUsername] = scala
      .Option(impl.username())
      .map(value => zio.aws.iot.model.primitives.MqttUsername(value))
    override val password: Option[MqttPassword] = scala
      .Option(impl.password())
      .map(value =>
        zio.aws.iot.model.primitives
          .MqttPassword(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val clientId: Option[MqttClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.iot.model.primitives.MqttClientId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.MqttContext
  ): zio.aws.iot.model.MqttContext.ReadOnly = new Wrapper(impl)
}
