package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Message,
  DateType,
  CertificateId,
  CertificateArn,
  AwsAccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OutgoingCertificate(
    certificateArn: Option[CertificateArn] = None,
    certificateId: Option[CertificateId] = None,
    transferredTo: Option[AwsAccountId] = None,
    transferDate: Option[DateType] = None,
    transferMessage: Option[Message] = None,
    creationDate: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.OutgoingCertificate = {
    import OutgoingCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.OutgoingCertificate
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        transferredTo.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.transferredTo)
      .optionallyWith(
        transferDate.map(value => DateType.unwrap(value): Instant)
      )(_.transferDate)
      .optionallyWith(
        transferMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.transferMessage)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.OutgoingCertificate.ReadOnly =
    zio.aws.iot.model.OutgoingCertificate.wrap(buildAwsValue())
}
object OutgoingCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.OutgoingCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.OutgoingCertificate =
      zio.aws.iot.model.OutgoingCertificate(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        transferredTo.map(value => value),
        transferDate.map(value => value),
        transferMessage.map(value => value),
        creationDate.map(value => value)
      )
    def certificateArn: Option[CertificateArn]
    def certificateId: Option[CertificateId]
    def transferredTo: Option[AwsAccountId]
    def transferDate: Option[DateType]
    def transferMessage: Option[Message]
    def creationDate: Option[DateType]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getTransferredTo: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("transferredTo", transferredTo)
    def getTransferDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("transferDate", transferDate)
    def getTransferMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("transferMessage", transferMessage)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.OutgoingCertificate
  ) extends zio.aws.iot.model.OutgoingCertificate.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val transferredTo: Option[AwsAccountId] = scala
      .Option(impl.transferredTo())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val transferDate: Option[DateType] = scala
      .Option(impl.transferDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val transferMessage: Option[Message] = scala
      .Option(impl.transferMessage())
      .map(value => zio.aws.iot.model.primitives.Message(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.OutgoingCertificate
  ): zio.aws.iot.model.OutgoingCertificate.ReadOnly = new Wrapper(impl)
}
