package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PercentValue, Percent}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PercentPair(
    percent: Option[Percent] = None,
    value: Option[PercentValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.PercentPair = {
    import PercentPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PercentPair
      .builder()
      .optionallyWith(
        percent.map(value => Percent.unwrap(value): java.lang.Double)
      )(_.percent)
      .optionallyWith(
        value.map(value => PercentValue.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PercentPair.ReadOnly =
    zio.aws.iot.model.PercentPair.wrap(buildAwsValue())
}
object PercentPair {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.PercentPair] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PercentPair = zio.aws.iot.model
      .PercentPair(percent.map(value => value), value.map(value => value))
    def percent: Option[Percent]
    def value: Option[PercentValue]
    def getPercent: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("percent", percent)
    def getValue: ZIO[Any, AwsError, PercentValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PercentPair
  ) extends zio.aws.iot.model.PercentPair.ReadOnly {
    override val percent: Option[Percent] = scala
      .Option(impl.percent())
      .map(value => zio.aws.iot.model.primitives.Percent(value))
    override val value: Option[PercentValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.iot.model.primitives.PercentValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PercentPair
  ): zio.aws.iot.model.PercentPair.ReadOnly = new Wrapper(impl)
}
