package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{PolicyVersionId, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PolicyVersionIdentifier(
    policyName: Option[PolicyName] = None,
    policyVersionId: Option[PolicyVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier = {
    import PolicyVersionIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        policyVersionId.map(value =>
          PolicyVersionId.unwrap(value): java.lang.String
        )
      )(_.policyVersionId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly =
    zio.aws.iot.model.PolicyVersionIdentifier.wrap(buildAwsValue())
}
object PolicyVersionIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PolicyVersionIdentifier =
      zio.aws.iot.model.PolicyVersionIdentifier(
        policyName.map(value => value),
        policyVersionId.map(value => value)
      )
    def policyName: Option[PolicyName]
    def policyVersionId: Option[PolicyVersionId]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getPolicyVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
  ) extends zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly {
    override val policyName: Option[PolicyName] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.iot.model.primitives.PolicyName(value))
    override val policyVersionId: Option[PolicyVersionId] = scala
      .Option(impl.policyVersionId())
      .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersionIdentifier
  ): zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly = new Wrapper(impl)
}
