package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  TemplateArn,
  DateType,
  TemplateName,
  TemplateDescription,
  Enabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ProvisioningTemplateSummary(
    templateArn: Option[TemplateArn] = None,
    templateName: Option[TemplateName] = None,
    description: Option[TemplateDescription] = None,
    creationDate: Option[DateType] = None,
    lastModifiedDate: Option[DateType] = None,
    enabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary = {
    import ProvisioningTemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateName.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.templateName)
      .optionallyWith(
        description.map(value =>
          TemplateDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly =
    zio.aws.iot.model.ProvisioningTemplateSummary.wrap(buildAwsValue())
}
object ProvisioningTemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ProvisioningTemplateSummary =
      zio.aws.iot.model.ProvisioningTemplateSummary(
        templateArn.map(value => value),
        templateName.map(value => value),
        description.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value),
        enabled.map(value => value)
      )
    def templateArn: Option[TemplateArn]
    def templateName: Option[TemplateName]
    def description: Option[TemplateDescription]
    def creationDate: Option[DateType]
    def lastModifiedDate: Option[DateType]
    def enabled: Option[Enabled]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getDescription: ZIO[Any, AwsError, TemplateDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
  ) extends zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly {
    override val templateArn: Option[TemplateArn] = scala
      .Option(impl.templateArn())
      .map(value => zio.aws.iot.model.primitives.TemplateArn(value))
    override val templateName: Option[TemplateName] = scala
      .Option(impl.templateName())
      .map(value => zio.aws.iot.model.primitives.TemplateName(value))
    override val description: Option[TemplateDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.TemplateDescription(value))
    override val creationDate: Option[DateType] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Option[DateType] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val enabled: Option[Enabled] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.iot.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary
  ): zio.aws.iot.model.ProvisioningTemplateSummary.ReadOnly = new Wrapper(impl)
}
