package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.NumberOfThings
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RateIncreaseCriteria(
    numberOfNotifiedThings: Option[NumberOfThings] = None,
    numberOfSucceededThings: Option[NumberOfThings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RateIncreaseCriteria = {
    import RateIncreaseCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
      .builder()
      .optionallyWith(
        numberOfNotifiedThings.map(value =>
          NumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfNotifiedThings)
      .optionallyWith(
        numberOfSucceededThings.map(value =>
          NumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfSucceededThings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RateIncreaseCriteria.ReadOnly =
    zio.aws.iot.model.RateIncreaseCriteria.wrap(buildAwsValue())
}
object RateIncreaseCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RateIncreaseCriteria =
      zio.aws.iot.model.RateIncreaseCriteria(
        numberOfNotifiedThings.map(value => value),
        numberOfSucceededThings.map(value => value)
      )
    def numberOfNotifiedThings: Option[NumberOfThings]
    def numberOfSucceededThings: Option[NumberOfThings]
    def getNumberOfNotifiedThings: ZIO[Any, AwsError, NumberOfThings] = AwsError
      .unwrapOptionField("numberOfNotifiedThings", numberOfNotifiedThings)
    def getNumberOfSucceededThings: ZIO[Any, AwsError, NumberOfThings] =
      AwsError.unwrapOptionField(
        "numberOfSucceededThings",
        numberOfSucceededThings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
  ) extends zio.aws.iot.model.RateIncreaseCriteria.ReadOnly {
    override val numberOfNotifiedThings: Option[NumberOfThings] = scala
      .Option(impl.numberOfNotifiedThings())
      .map(value => zio.aws.iot.model.primitives.NumberOfThings(value))
    override val numberOfSucceededThings: Option[NumberOfThings] = scala
      .Option(impl.numberOfSucceededThings())
      .map(value => zio.aws.iot.model.primitives.NumberOfThings(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
  ): zio.aws.iot.model.RateIncreaseCriteria.ReadOnly = new Wrapper(impl)
}
