package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SetAsActiveFlag, CertificatePem}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterCertificateRequest(
    certificatePem: CertificatePem,
    caCertificatePem: Option[CertificatePem] = None,
    setAsActive: Option[SetAsActiveFlag] = None,
    status: Option[zio.aws.iot.model.CertificateStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterCertificateRequest = {
    import RegisterCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterCertificateRequest
      .builder()
      .certificatePem(CertificatePem.unwrap(certificatePem): java.lang.String)
      .optionallyWith(
        caCertificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.caCertificatePem)
      .optionallyWith(
        setAsActive.map(value =>
          SetAsActiveFlag.unwrap(value): java.lang.Boolean
        )
      )(_.setAsActive)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegisterCertificateRequest.ReadOnly =
    zio.aws.iot.model.RegisterCertificateRequest.wrap(buildAwsValue())
}
object RegisterCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterCertificateRequest =
      zio.aws.iot.model.RegisterCertificateRequest(
        certificatePem,
        caCertificatePem.map(value => value),
        setAsActive.map(value => value),
        status.map(value => value)
      )
    def certificatePem: CertificatePem
    def caCertificatePem: Option[CertificatePem]
    def setAsActive: Option[SetAsActiveFlag]
    def status: Option[zio.aws.iot.model.CertificateStatus]
    def getCertificatePem: ZIO[Any, Nothing, CertificatePem] =
      ZIO.succeed(certificatePem)
    def getCaCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("caCertificatePem", caCertificatePem)
    def getSetAsActive: ZIO[Any, AwsError, SetAsActiveFlag] =
      AwsError.unwrapOptionField("setAsActive", setAsActive)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterCertificateRequest
  ) extends zio.aws.iot.model.RegisterCertificateRequest.ReadOnly {
    override val certificatePem: CertificatePem =
      zio.aws.iot.model.primitives.CertificatePem(impl.certificatePem())
    override val caCertificatePem: Option[CertificatePem] = scala
      .Option(impl.caCertificatePem())
      .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val setAsActive: Option[SetAsActiveFlag] = scala
      .Option(impl.setAsActive())
      .map(value => zio.aws.iot.model.primitives.SetAsActiveFlag(value))
    override val status: Option[zio.aws.iot.model.CertificateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.iot.model.CertificateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterCertificateRequest
  ): zio.aws.iot.model.RegisterCertificateRequest.ReadOnly = new Wrapper(impl)
}
