package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{CertificateId, CertificateArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterCertificateWithoutCaResponse(
    certificateArn: Option[CertificateArn] = None,
    certificateId: Option[CertificateId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse = {
    import RegisterCertificateWithoutCaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly =
    zio.aws.iot.model.RegisterCertificateWithoutCaResponse.wrap(buildAwsValue())
}
object RegisterCertificateWithoutCaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterCertificateWithoutCaResponse =
      zio.aws.iot.model.RegisterCertificateWithoutCaResponse(
        certificateArn.map(value => value),
        certificateId.map(value => value)
      )
    def certificateArn: Option[CertificateArn]
    def certificateId: Option[CertificateId]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse
  ) extends zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly {
    override val certificateArn: Option[CertificateArn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Option[CertificateId] = scala
      .Option(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse
  ): zio.aws.iot.model.RegisterCertificateWithoutCaResponse.ReadOnly =
    new Wrapper(impl)
}
