package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Value, Parameter, TemplateBody}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterThingRequest(
    templateBody: TemplateBody,
    parameters: Option[Map[Parameter, Value]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterThingRequest = {
    import RegisterThingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterThingRequest
      .builder()
      .templateBody(TemplateBody.unwrap(templateBody): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (Parameter.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegisterThingRequest.ReadOnly =
    zio.aws.iot.model.RegisterThingRequest.wrap(buildAwsValue())
}
object RegisterThingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterThingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterThingRequest = zio.aws.iot.model
      .RegisterThingRequest(templateBody, parameters.map(value => value))
    def templateBody: TemplateBody
    def parameters: Option[Map[Parameter, Value]]
    def getTemplateBody: ZIO[Any, Nothing, TemplateBody] =
      ZIO.succeed(templateBody)
    def getParameters: ZIO[Any, AwsError, Map[Parameter, Value]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterThingRequest
  ) extends zio.aws.iot.model.RegisterThingRequest.ReadOnly {
    override val templateBody: TemplateBody =
      zio.aws.iot.model.primitives.TemplateBody(impl.templateBody())
    override val parameters: Option[Map[Parameter, Value]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives
              .Parameter(key) -> zio.aws.iot.model.primitives.Value(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterThingRequest
  ): zio.aws.iot.model.RegisterThingRequest.ReadOnly = new Wrapper(impl)
}
