package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RoleAliasArn,
  RoleArn,
  CertificateId,
  ClientId,
  CognitoIdentityPoolId,
  AwsAccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceIdentifier(
    deviceCertificateId: Option[CertificateId] = None,
    caCertificateId: Option[CertificateId] = None,
    cognitoIdentityPoolId: Option[CognitoIdentityPoolId] = None,
    clientId: Option[ClientId] = None,
    policyVersionIdentifier: Option[zio.aws.iot.model.PolicyVersionIdentifier] =
      None,
    account: Option[AwsAccountId] = None,
    iamRoleArn: Option[RoleArn] = None,
    roleAliasArn: Option[RoleAliasArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ResourceIdentifier = {
    import ResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ResourceIdentifier
      .builder()
      .optionallyWith(
        deviceCertificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.deviceCertificateId)
      .optionallyWith(
        caCertificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.caCertificateId)
      .optionallyWith(
        cognitoIdentityPoolId.map(value =>
          CognitoIdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.cognitoIdentityPoolId)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        policyVersionIdentifier.map(value => value.buildAwsValue())
      )(_.policyVersionIdentifier)
      .optionallyWith(
        account.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        iamRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        roleAliasArn.map(value => RoleAliasArn.unwrap(value): java.lang.String)
      )(_.roleAliasArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ResourceIdentifier.ReadOnly =
    zio.aws.iot.model.ResourceIdentifier.wrap(buildAwsValue())
}
object ResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ResourceIdentifier =
      zio.aws.iot.model.ResourceIdentifier(
        deviceCertificateId.map(value => value),
        caCertificateId.map(value => value),
        cognitoIdentityPoolId.map(value => value),
        clientId.map(value => value),
        policyVersionIdentifier.map(value => value.asEditable),
        account.map(value => value),
        iamRoleArn.map(value => value),
        roleAliasArn.map(value => value)
      )
    def deviceCertificateId: Option[CertificateId]
    def caCertificateId: Option[CertificateId]
    def cognitoIdentityPoolId: Option[CognitoIdentityPoolId]
    def clientId: Option[ClientId]
    def policyVersionIdentifier
        : Option[zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly]
    def account: Option[AwsAccountId]
    def iamRoleArn: Option[RoleArn]
    def roleAliasArn: Option[RoleAliasArn]
    def getDeviceCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("deviceCertificateId", deviceCertificateId)
    def getCaCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("caCertificateId", caCertificateId)
    def getCognitoIdentityPoolId: ZIO[Any, AwsError, CognitoIdentityPoolId] =
      AwsError.unwrapOptionField("cognitoIdentityPoolId", cognitoIdentityPoolId)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getPolicyVersionIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "policyVersionIdentifier",
      policyVersionIdentifier
    )
    def getAccount: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("account", account)
    def getIamRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getRoleAliasArn: ZIO[Any, AwsError, RoleAliasArn] =
      AwsError.unwrapOptionField("roleAliasArn", roleAliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ResourceIdentifier
  ) extends zio.aws.iot.model.ResourceIdentifier.ReadOnly {
    override val deviceCertificateId: Option[CertificateId] = scala
      .Option(impl.deviceCertificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val caCertificateId: Option[CertificateId] = scala
      .Option(impl.caCertificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val cognitoIdentityPoolId: Option[CognitoIdentityPoolId] = scala
      .Option(impl.cognitoIdentityPoolId())
      .map(value => zio.aws.iot.model.primitives.CognitoIdentityPoolId(value))
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.iot.model.primitives.ClientId(value))
    override val policyVersionIdentifier
        : Option[zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly] = scala
      .Option(impl.policyVersionIdentifier())
      .map(value => zio.aws.iot.model.PolicyVersionIdentifier.wrap(value))
    override val account: Option[AwsAccountId] = scala
      .Option(impl.account())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val iamRoleArn: Option[RoleArn] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val roleAliasArn: Option[RoleAliasArn] = scala
      .Option(impl.roleAliasArn())
      .map(value => zio.aws.iot.model.primitives.RoleAliasArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ResourceIdentifier
  ): zio.aws.iot.model.ResourceIdentifier.ReadOnly = new Wrapper(impl)
}
