package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Key, BucketName, AwsArn}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Action(
    roleArn: AwsArn,
    bucketName: BucketName,
    key: Key,
    cannedAcl: Option[zio.aws.iot.model.CannedAccessControlList] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.S3Action = {
    import S3Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.S3Action
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .key(Key.unwrap(key): java.lang.String)
      .optionallyWith(cannedAcl.map(value => value.unwrap))(_.cannedAcl)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.S3Action.ReadOnly =
    zio.aws.iot.model.S3Action.wrap(buildAwsValue())
}
object S3Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.S3Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.S3Action = zio.aws.iot.model.S3Action(
      roleArn,
      bucketName,
      key,
      cannedAcl.map(value => value)
    )
    def roleArn: AwsArn
    def bucketName: BucketName
    def key: Key
    def cannedAcl: Option[zio.aws.iot.model.CannedAccessControlList]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getKey: ZIO[Any, Nothing, Key] = ZIO.succeed(key)
    def getCannedAcl
        : ZIO[Any, AwsError, zio.aws.iot.model.CannedAccessControlList] =
      AwsError.unwrapOptionField("cannedAcl", cannedAcl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.S3Action
  ) extends zio.aws.iot.model.S3Action.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val bucketName: BucketName =
      zio.aws.iot.model.primitives.BucketName(impl.bucketName())
    override val key: Key = zio.aws.iot.model.primitives.Key(impl.key())
    override val cannedAcl: Option[zio.aws.iot.model.CannedAccessControlList] =
      scala
        .Option(impl.cannedAcl())
        .map(value => zio.aws.iot.model.CannedAccessControlList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.S3Action
  ): zio.aws.iot.model.S3Action.ReadOnly = new Wrapper(impl)
}
