package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{S3Version, S3Key, S3Bucket}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucket: Option[S3Bucket] = None,
    key: Option[S3Key] = None,
    version: Option[S3Version] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.S3Location
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(key.map(value => S3Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        version.map(value => S3Version.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.S3Location.ReadOnly =
    zio.aws.iot.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.S3Location] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.S3Location = zio.aws.iot.model.S3Location(
      bucket.map(value => value),
      key.map(value => value),
      version.map(value => value)
    )
    def bucket: Option[S3Bucket]
    def key: Option[S3Key]
    def version: Option[S3Version]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("key", key)
    def getVersion: ZIO[Any, AwsError, S3Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.S3Location
  ) extends zio.aws.iot.model.S3Location.ReadOnly {
    override val bucket: Option[S3Bucket] = scala
      .Option(impl.bucket())
      .map(value => zio.aws.iot.model.primitives.S3Bucket(value))
    override val key: Option[S3Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.iot.model.primitives.S3Key(value))
    override val version: Option[S3Version] = scala
      .Option(impl.version())
      .map(value => zio.aws.iot.model.primitives.S3Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.S3Location
  ): zio.aws.iot.model.S3Location.ReadOnly = new Wrapper(impl)
}
