package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DayOfMonth,
  ScheduledAuditArn,
  ScheduledAuditName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScheduledAuditMetadata(
    scheduledAuditName: Option[ScheduledAuditName] = None,
    scheduledAuditArn: Option[ScheduledAuditArn] = None,
    frequency: Option[zio.aws.iot.model.AuditFrequency] = None,
    dayOfMonth: Option[DayOfMonth] = None,
    dayOfWeek: Option[zio.aws.iot.model.DayOfWeek] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata = {
    import ScheduledAuditMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
      .builder()
      .optionallyWith(
        scheduledAuditName.map(value =>
          ScheduledAuditName.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditName)
      .optionallyWith(
        scheduledAuditArn.map(value =>
          ScheduledAuditArn.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditArn)
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): java.lang.String)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly =
    zio.aws.iot.model.ScheduledAuditMetadata.wrap(buildAwsValue())
}
object ScheduledAuditMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ScheduledAuditMetadata =
      zio.aws.iot.model.ScheduledAuditMetadata(
        scheduledAuditName.map(value => value),
        scheduledAuditArn.map(value => value),
        frequency.map(value => value),
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value)
      )
    def scheduledAuditName: Option[ScheduledAuditName]
    def scheduledAuditArn: Option[ScheduledAuditArn]
    def frequency: Option[zio.aws.iot.model.AuditFrequency]
    def dayOfMonth: Option[DayOfMonth]
    def dayOfWeek: Option[zio.aws.iot.model.DayOfWeek]
    def getScheduledAuditName: ZIO[Any, AwsError, ScheduledAuditName] =
      AwsError.unwrapOptionField("scheduledAuditName", scheduledAuditName)
    def getScheduledAuditArn: ZIO[Any, AwsError, ScheduledAuditArn] =
      AwsError.unwrapOptionField("scheduledAuditArn", scheduledAuditArn)
    def getFrequency: ZIO[Any, AwsError, zio.aws.iot.model.AuditFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.iot.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
  ) extends zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly {
    override val scheduledAuditName: Option[ScheduledAuditName] = scala
      .Option(impl.scheduledAuditName())
      .map(value => zio.aws.iot.model.primitives.ScheduledAuditName(value))
    override val scheduledAuditArn: Option[ScheduledAuditArn] = scala
      .Option(impl.scheduledAuditArn())
      .map(value => zio.aws.iot.model.primitives.ScheduledAuditArn(value))
    override val frequency: Option[zio.aws.iot.model.AuditFrequency] = scala
      .Option(impl.frequency())
      .map(value => zio.aws.iot.model.AuditFrequency.wrap(value))
    override val dayOfMonth: Option[DayOfMonth] = scala
      .Option(impl.dayOfMonth())
      .map(value => zio.aws.iot.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Option[zio.aws.iot.model.DayOfWeek] = scala
      .Option(impl.dayOfWeek())
      .map(value => zio.aws.iot.model.DayOfWeek.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
  ): zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly = new Wrapper(impl)
}
