package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SecurityProfileTargetArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SecurityProfileTarget(arn: SecurityProfileTargetArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SecurityProfileTarget = {
    import SecurityProfileTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SecurityProfileTarget
      .builder()
      .arn(SecurityProfileTargetArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SecurityProfileTarget.ReadOnly =
    zio.aws.iot.model.SecurityProfileTarget.wrap(buildAwsValue())
}
object SecurityProfileTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SecurityProfileTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SecurityProfileTarget =
      zio.aws.iot.model.SecurityProfileTarget(arn)
    def arn: SecurityProfileTargetArn
    def getArn: ZIO[Any, Nothing, SecurityProfileTargetArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SecurityProfileTarget
  ) extends zio.aws.iot.model.SecurityProfileTarget.ReadOnly {
    override val arn: SecurityProfileTargetArn =
      zio.aws.iot.model.primitives.SecurityProfileTargetArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SecurityProfileTarget
  ): zio.aws.iot.model.SecurityProfileTarget.ReadOnly = new Wrapper(impl)
}
