package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ServerCertificateStatusDetail,
  AcmCertificateArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServerCertificateSummary(
    serverCertificateArn: Option[AcmCertificateArn] = None,
    serverCertificateStatus: Option[zio.aws.iot.model.ServerCertificateStatus] =
      None,
    serverCertificateStatusDetail: Option[ServerCertificateStatusDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ServerCertificateSummary = {
    import ServerCertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ServerCertificateSummary
      .builder()
      .optionallyWith(
        serverCertificateArn.map(value =>
          AcmCertificateArn.unwrap(value): java.lang.String
        )
      )(_.serverCertificateArn)
      .optionallyWith(serverCertificateStatus.map(value => value.unwrap))(
        _.serverCertificateStatus
      )
      .optionallyWith(
        serverCertificateStatusDetail.map(value =>
          ServerCertificateStatusDetail.unwrap(value): java.lang.String
        )
      )(_.serverCertificateStatusDetail)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ServerCertificateSummary.ReadOnly =
    zio.aws.iot.model.ServerCertificateSummary.wrap(buildAwsValue())
}
object ServerCertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ServerCertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ServerCertificateSummary =
      zio.aws.iot.model.ServerCertificateSummary(
        serverCertificateArn.map(value => value),
        serverCertificateStatus.map(value => value),
        serverCertificateStatusDetail.map(value => value)
      )
    def serverCertificateArn: Option[AcmCertificateArn]
    def serverCertificateStatus
        : Option[zio.aws.iot.model.ServerCertificateStatus]
    def serverCertificateStatusDetail: Option[ServerCertificateStatusDetail]
    def getServerCertificateArn: ZIO[Any, AwsError, AcmCertificateArn] =
      AwsError.unwrapOptionField("serverCertificateArn", serverCertificateArn)
    def getServerCertificateStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.ServerCertificateStatus] =
      AwsError.unwrapOptionField(
        "serverCertificateStatus",
        serverCertificateStatus
      )
    def getServerCertificateStatusDetail
        : ZIO[Any, AwsError, ServerCertificateStatusDetail] =
      AwsError.unwrapOptionField(
        "serverCertificateStatusDetail",
        serverCertificateStatusDetail
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ServerCertificateSummary
  ) extends zio.aws.iot.model.ServerCertificateSummary.ReadOnly {
    override val serverCertificateArn: Option[AcmCertificateArn] = scala
      .Option(impl.serverCertificateArn())
      .map(value => zio.aws.iot.model.primitives.AcmCertificateArn(value))
    override val serverCertificateStatus
        : Option[zio.aws.iot.model.ServerCertificateStatus] = scala
      .Option(impl.serverCertificateStatus())
      .map(value => zio.aws.iot.model.ServerCertificateStatus.wrap(value))
    override val serverCertificateStatusDetail
        : Option[ServerCertificateStatusDetail] = scala
      .Option(impl.serverCertificateStatusDetail())
      .map(value =>
        zio.aws.iot.model.primitives.ServerCertificateStatusDetail(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ServerCertificateSummary
  ): zio.aws.iot.model.ServerCertificateSummary.ReadOnly = new Wrapper(impl)
}
