package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ClientRequestToken,
  MitigationActionName,
  AuditCheckName,
  MitigationActionsTaskId
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartAuditMitigationActionsTaskRequest(
    taskId: MitigationActionsTaskId,
    target: zio.aws.iot.model.AuditMitigationActionsTaskTarget,
    auditCheckToActionsMapping: Map[AuditCheckName, Iterable[
      MitigationActionName
    ]],
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest = {
    import StartAuditMitigationActionsTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .target(target.buildAwsValue())
      .auditCheckToActionsMapping(
        auditCheckToActionsMapping
          .map({ case (key, value) =>
            (AuditCheckName.unwrap(key): java.lang.String) -> value.map {
              item =>
                MitigationActionName.unwrap(item): java.lang.String
            }.asJavaCollection
          })
          .asJava
      )
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.StartAuditMitigationActionsTaskRequest.ReadOnly =
    zio.aws.iot.model.StartAuditMitigationActionsTaskRequest
      .wrap(buildAwsValue())
}
object StartAuditMitigationActionsTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartAuditMitigationActionsTaskRequest =
      zio.aws.iot.model.StartAuditMitigationActionsTaskRequest(
        taskId,
        target.asEditable,
        auditCheckToActionsMapping,
        clientRequestToken
      )
    def taskId: MitigationActionsTaskId
    def target: zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly
    def auditCheckToActionsMapping
        : Map[AuditCheckName, List[MitigationActionName]]
    def clientRequestToken: ClientRequestToken
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
    def getTarget: ZIO[
      Any,
      Nothing,
      zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly
    ] = ZIO.succeed(target)
    def getAuditCheckToActionsMapping
        : ZIO[Any, Nothing, Map[AuditCheckName, List[MitigationActionName]]] =
      ZIO.succeed(auditCheckToActionsMapping)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest
  ) extends zio.aws.iot.model.StartAuditMitigationActionsTaskRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
    override val target
        : zio.aws.iot.model.AuditMitigationActionsTaskTarget.ReadOnly =
      zio.aws.iot.model.AuditMitigationActionsTaskTarget.wrap(impl.target())
    override val auditCheckToActionsMapping
        : Map[AuditCheckName, List[MitigationActionName]] = impl
      .auditCheckToActionsMapping()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iot.model.primitives.AuditCheckName(key) -> value.asScala.map {
          item =>
            zio.aws.iot.model.primitives.MitigationActionName(item)
        }.toList
      })
      .toMap
    override val clientRequestToken: ClientRequestToken =
      zio.aws.iot.model.primitives.ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest
  ): zio.aws.iot.model.StartAuditMitigationActionsTaskRequest.ReadOnly =
    new Wrapper(impl)
}
