package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ClientRequestToken,
  NullableBoolean,
  MitigationActionName,
  MitigationActionsTaskId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartDetectMitigationActionsTaskRequest(
    taskId: MitigationActionsTaskId,
    target: zio.aws.iot.model.DetectMitigationActionsTaskTarget,
    actions: Iterable[MitigationActionName],
    violationEventOccurrenceRange: Option[
      zio.aws.iot.model.ViolationEventOccurrenceRange
    ] = None,
    includeOnlyActiveViolations: Option[NullableBoolean] = None,
    includeSuppressedAlerts: Option[NullableBoolean] = None,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest = {
    import StartDetectMitigationActionsTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest
      .builder()
      .taskId(MitigationActionsTaskId.unwrap(taskId): java.lang.String)
      .target(target.buildAwsValue())
      .actions(actions.map { item =>
        MitigationActionName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        violationEventOccurrenceRange.map(value => value.buildAwsValue())
      )(_.violationEventOccurrenceRange)
      .optionallyWith(
        includeOnlyActiveViolations.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeOnlyActiveViolations)
      .optionallyWith(
        includeSuppressedAlerts.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeSuppressedAlerts)
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.StartDetectMitigationActionsTaskRequest.ReadOnly =
    zio.aws.iot.model.StartDetectMitigationActionsTaskRequest
      .wrap(buildAwsValue())
}
object StartDetectMitigationActionsTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartDetectMitigationActionsTaskRequest =
      zio.aws.iot.model.StartDetectMitigationActionsTaskRequest(
        taskId,
        target.asEditable,
        actions,
        violationEventOccurrenceRange.map(value => value.asEditable),
        includeOnlyActiveViolations.map(value => value),
        includeSuppressedAlerts.map(value => value),
        clientRequestToken
      )
    def taskId: MitigationActionsTaskId
    def target: zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly
    def actions: List[MitigationActionName]
    def violationEventOccurrenceRange
        : Option[zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly]
    def includeOnlyActiveViolations: Option[NullableBoolean]
    def includeSuppressedAlerts: Option[NullableBoolean]
    def clientRequestToken: ClientRequestToken
    def getTaskId: ZIO[Any, Nothing, MitigationActionsTaskId] =
      ZIO.succeed(taskId)
    def getTarget: ZIO[
      Any,
      Nothing,
      zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly
    ] = ZIO.succeed(target)
    def getActions: ZIO[Any, Nothing, List[MitigationActionName]] =
      ZIO.succeed(actions)
    def getViolationEventOccurrenceRange: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "violationEventOccurrenceRange",
      violationEventOccurrenceRange
    )
    def getIncludeOnlyActiveViolations: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "includeOnlyActiveViolations",
        includeOnlyActiveViolations
      )
    def getIncludeSuppressedAlerts: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "includeSuppressedAlerts",
        includeSuppressedAlerts
      )
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest
  ) extends zio.aws.iot.model.StartDetectMitigationActionsTaskRequest.ReadOnly {
    override val taskId: MitigationActionsTaskId =
      zio.aws.iot.model.primitives.MitigationActionsTaskId(impl.taskId())
    override val target
        : zio.aws.iot.model.DetectMitigationActionsTaskTarget.ReadOnly =
      zio.aws.iot.model.DetectMitigationActionsTaskTarget.wrap(impl.target())
    override val actions: List[MitigationActionName] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.iot.model.primitives.MitigationActionName(item)
      }
      .toList
    override val violationEventOccurrenceRange
        : Option[zio.aws.iot.model.ViolationEventOccurrenceRange.ReadOnly] =
      scala
        .Option(impl.violationEventOccurrenceRange())
        .map(value =>
          zio.aws.iot.model.ViolationEventOccurrenceRange.wrap(value)
        )
    override val includeOnlyActiveViolations: Option[NullableBoolean] = scala
      .Option(impl.includeOnlyActiveViolations())
      .map(value => zio.aws.iot.model.primitives.NullableBoolean(value))
    override val includeSuppressedAlerts: Option[NullableBoolean] = scala
      .Option(impl.includeSuppressedAlerts())
      .map(value => zio.aws.iot.model.primitives.NullableBoolean(value))
    override val clientRequestToken: ClientRequestToken =
      zio.aws.iot.model.primitives.ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest
  ): zio.aws.iot.model.StartDetectMitigationActionsTaskRequest.ReadOnly =
    new Wrapper(impl)
}
