package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RoleArn,
  RegistryS3KeyName,
  RegistryS3BucketName,
  TemplateBody
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartThingRegistrationTaskRequest(
    templateBody: TemplateBody,
    inputFileBucket: RegistryS3BucketName,
    inputFileKey: RegistryS3KeyName,
    roleArn: RoleArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest = {
    import StartThingRegistrationTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest
      .builder()
      .templateBody(TemplateBody.unwrap(templateBody): java.lang.String)
      .inputFileBucket(
        RegistryS3BucketName.unwrap(inputFileBucket): java.lang.String
      )
      .inputFileKey(RegistryS3KeyName.unwrap(inputFileKey): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StartThingRegistrationTaskRequest.ReadOnly =
    zio.aws.iot.model.StartThingRegistrationTaskRequest.wrap(buildAwsValue())
}
object StartThingRegistrationTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartThingRegistrationTaskRequest =
      zio.aws.iot.model.StartThingRegistrationTaskRequest(
        templateBody,
        inputFileBucket,
        inputFileKey,
        roleArn
      )
    def templateBody: TemplateBody
    def inputFileBucket: RegistryS3BucketName
    def inputFileKey: RegistryS3KeyName
    def roleArn: RoleArn
    def getTemplateBody: ZIO[Any, Nothing, TemplateBody] =
      ZIO.succeed(templateBody)
    def getInputFileBucket: ZIO[Any, Nothing, RegistryS3BucketName] =
      ZIO.succeed(inputFileBucket)
    def getInputFileKey: ZIO[Any, Nothing, RegistryS3KeyName] =
      ZIO.succeed(inputFileKey)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest
  ) extends zio.aws.iot.model.StartThingRegistrationTaskRequest.ReadOnly {
    override val templateBody: TemplateBody =
      zio.aws.iot.model.primitives.TemplateBody(impl.templateBody())
    override val inputFileBucket: RegistryS3BucketName =
      zio.aws.iot.model.primitives.RegistryS3BucketName(impl.inputFileBucket())
    override val inputFileKey: RegistryS3KeyName =
      zio.aws.iot.model.primitives.RegistryS3KeyName(impl.inputFileKey())
    override val roleArn: RoleArn =
      zio.aws.iot.model.primitives.RoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest
  ): zio.aws.iot.model.StartThingRegistrationTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
