package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.TaskId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartThingRegistrationTaskResponse(
    taskId: Option[TaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse = {
    import StartThingRegistrationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value => TaskId.unwrap(value): java.lang.String)
      )(_.taskId)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly =
    zio.aws.iot.model.StartThingRegistrationTaskResponse.wrap(buildAwsValue())
}
object StartThingRegistrationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartThingRegistrationTaskResponse =
      zio.aws.iot.model
        .StartThingRegistrationTaskResponse(taskId.map(value => value))
    def taskId: Option[TaskId]
    def getTaskId: ZIO[Any, AwsError, TaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse
  ) extends zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly {
    override val taskId: Option[TaskId] = scala
      .Option(impl.taskId())
      .map(value => zio.aws.iot.model.primitives.TaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse
  ): zio.aws.iot.model.StartThingRegistrationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
