package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsArn,
  StateMachineName,
  ExecutionNamePrefix
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StepFunctionsAction(
    executionNamePrefix: Option[ExecutionNamePrefix] = None,
    stateMachineName: StateMachineName,
    roleArn: AwsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StepFunctionsAction = {
    import StepFunctionsAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StepFunctionsAction
      .builder()
      .optionallyWith(
        executionNamePrefix.map(value =>
          ExecutionNamePrefix.unwrap(value): java.lang.String
        )
      )(_.executionNamePrefix)
      .stateMachineName(
        StateMachineName.unwrap(stateMachineName): java.lang.String
      )
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StepFunctionsAction.ReadOnly =
    zio.aws.iot.model.StepFunctionsAction.wrap(buildAwsValue())
}
object StepFunctionsAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StepFunctionsAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StepFunctionsAction =
      zio.aws.iot.model.StepFunctionsAction(
        executionNamePrefix.map(value => value),
        stateMachineName,
        roleArn
      )
    def executionNamePrefix: Option[ExecutionNamePrefix]
    def stateMachineName: StateMachineName
    def roleArn: AwsArn
    def getExecutionNamePrefix: ZIO[Any, AwsError, ExecutionNamePrefix] =
      AwsError.unwrapOptionField("executionNamePrefix", executionNamePrefix)
    def getStateMachineName: ZIO[Any, Nothing, StateMachineName] =
      ZIO.succeed(stateMachineName)
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StepFunctionsAction
  ) extends zio.aws.iot.model.StepFunctionsAction.ReadOnly {
    override val executionNamePrefix: Option[ExecutionNamePrefix] = scala
      .Option(impl.executionNamePrefix())
      .map(value => zio.aws.iot.model.primitives.ExecutionNamePrefix(value))
    override val stateMachineName: StateMachineName =
      zio.aws.iot.model.primitives.StateMachineName(impl.stateMachineName())
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StepFunctionsAction
  ): zio.aws.iot.model.StepFunctionsAction.ReadOnly = new Wrapper(impl)
}
