package zio.aws.iot.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleArn,
  DateType,
  StreamId,
  StreamArn,
  StreamVersion,
  StreamDescription
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StreamInfo(
    streamId: Option[StreamId] = None,
    streamArn: Option[StreamArn] = None,
    streamVersion: Option[StreamVersion] = None,
    description: Option[StreamDescription] = None,
    files: Option[Iterable[zio.aws.iot.model.StreamFile]] = None,
    createdAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.StreamInfo = {
    import StreamInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StreamInfo
      .builder()
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        streamVersion.map(value => StreamVersion.unwrap(value): Integer)
      )(_.streamVersion)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        files.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.files)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StreamInfo.ReadOnly =
    zio.aws.iot.model.StreamInfo.wrap(buildAwsValue())
}
object StreamInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.StreamInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StreamInfo = zio.aws.iot.model.StreamInfo(
      streamId.map(value => value),
      streamArn.map(value => value),
      streamVersion.map(value => value),
      description.map(value => value),
      files.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      roleArn.map(value => value)
    )
    def streamId: Option[StreamId]
    def streamArn: Option[StreamArn]
    def streamVersion: Option[StreamVersion]
    def description: Option[StreamDescription]
    def files: Option[List[zio.aws.iot.model.StreamFile.ReadOnly]]
    def createdAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def roleArn: Option[RoleArn]
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getStreamVersion: ZIO[Any, AwsError, StreamVersion] =
      AwsError.unwrapOptionField("streamVersion", streamVersion)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFiles
        : ZIO[Any, AwsError, List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      AwsError.unwrapOptionField("files", files)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StreamInfo
  ) extends zio.aws.iot.model.StreamInfo.ReadOnly {
    override val streamId: Option[StreamId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.iot.model.primitives.StreamId(value))
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.iot.model.primitives.StreamArn(value))
    override val streamVersion: Option[StreamVersion] = scala
      .Option(impl.streamVersion())
      .map(value => zio.aws.iot.model.primitives.StreamVersion(value))
    override val description: Option[StreamDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
    override val files: Option[List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      scala
        .Option(impl.files())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.StreamFile.wrap(item)
          }.toList
        )
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StreamInfo
  ): zio.aws.iot.model.StreamInfo.ReadOnly = new Wrapper(impl)
}
