package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  StreamDescription,
  StreamVersion,
  StreamArn,
  StreamId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StreamSummary(
    streamId: Option[StreamId] = None,
    streamArn: Option[StreamArn] = None,
    streamVersion: Option[StreamVersion] = None,
    description: Option[StreamDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StreamSummary = {
    import StreamSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StreamSummary
      .builder()
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        streamVersion.map(value => StreamVersion.unwrap(value): Integer)
      )(_.streamVersion)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StreamSummary.ReadOnly =
    zio.aws.iot.model.StreamSummary.wrap(buildAwsValue())
}
object StreamSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.StreamSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StreamSummary =
      zio.aws.iot.model.StreamSummary(
        streamId.map(value => value),
        streamArn.map(value => value),
        streamVersion.map(value => value),
        description.map(value => value)
      )
    def streamId: Option[StreamId]
    def streamArn: Option[StreamArn]
    def streamVersion: Option[StreamVersion]
    def description: Option[StreamDescription]
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getStreamVersion: ZIO[Any, AwsError, StreamVersion] =
      AwsError.unwrapOptionField("streamVersion", streamVersion)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StreamSummary
  ) extends zio.aws.iot.model.StreamSummary.ReadOnly {
    override val streamId: Option[StreamId] = scala
      .Option(impl.streamId())
      .map(value => zio.aws.iot.model.primitives.StreamId(value))
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.iot.model.primitives.StreamArn(value))
    override val streamVersion: Option[StreamVersion] = scala
      .Option(impl.streamVersion())
      .map(value => zio.aws.iot.model.primitives.StreamVersion(value))
    override val description: Option[StreamDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StreamSummary
  ): zio.aws.iot.model.StreamSummary.ReadOnly = new Wrapper(impl)
}
