package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  FailedFindingsCount,
  SkippedFindingsCount,
  TotalFindingsCount,
  SucceededFindingsCount,
  CanceledFindingsCount
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TaskStatisticsForAuditCheck(
    totalFindingsCount: Option[TotalFindingsCount] = None,
    failedFindingsCount: Option[FailedFindingsCount] = None,
    succeededFindingsCount: Option[SucceededFindingsCount] = None,
    skippedFindingsCount: Option[SkippedFindingsCount] = None,
    canceledFindingsCount: Option[CanceledFindingsCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck = {
    import TaskStatisticsForAuditCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
      .builder()
      .optionallyWith(
        totalFindingsCount.map(value =>
          TotalFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.totalFindingsCount)
      .optionallyWith(
        failedFindingsCount.map(value =>
          FailedFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.failedFindingsCount)
      .optionallyWith(
        succeededFindingsCount.map(value =>
          SucceededFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.succeededFindingsCount)
      .optionallyWith(
        skippedFindingsCount.map(value =>
          SkippedFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.skippedFindingsCount)
      .optionallyWith(
        canceledFindingsCount.map(value =>
          CanceledFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.canceledFindingsCount)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly =
    zio.aws.iot.model.TaskStatisticsForAuditCheck.wrap(buildAwsValue())
}
object TaskStatisticsForAuditCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TaskStatisticsForAuditCheck =
      zio.aws.iot.model.TaskStatisticsForAuditCheck(
        totalFindingsCount.map(value => value),
        failedFindingsCount.map(value => value),
        succeededFindingsCount.map(value => value),
        skippedFindingsCount.map(value => value),
        canceledFindingsCount.map(value => value)
      )
    def totalFindingsCount: Option[TotalFindingsCount]
    def failedFindingsCount: Option[FailedFindingsCount]
    def succeededFindingsCount: Option[SucceededFindingsCount]
    def skippedFindingsCount: Option[SkippedFindingsCount]
    def canceledFindingsCount: Option[CanceledFindingsCount]
    def getTotalFindingsCount: ZIO[Any, AwsError, TotalFindingsCount] =
      AwsError.unwrapOptionField("totalFindingsCount", totalFindingsCount)
    def getFailedFindingsCount: ZIO[Any, AwsError, FailedFindingsCount] =
      AwsError.unwrapOptionField("failedFindingsCount", failedFindingsCount)
    def getSucceededFindingsCount: ZIO[Any, AwsError, SucceededFindingsCount] =
      AwsError.unwrapOptionField(
        "succeededFindingsCount",
        succeededFindingsCount
      )
    def getSkippedFindingsCount: ZIO[Any, AwsError, SkippedFindingsCount] =
      AwsError.unwrapOptionField("skippedFindingsCount", skippedFindingsCount)
    def getCanceledFindingsCount: ZIO[Any, AwsError, CanceledFindingsCount] =
      AwsError.unwrapOptionField("canceledFindingsCount", canceledFindingsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
  ) extends zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly {
    override val totalFindingsCount: Option[TotalFindingsCount] = scala
      .Option(impl.totalFindingsCount())
      .map(value => zio.aws.iot.model.primitives.TotalFindingsCount(value))
    override val failedFindingsCount: Option[FailedFindingsCount] = scala
      .Option(impl.failedFindingsCount())
      .map(value => zio.aws.iot.model.primitives.FailedFindingsCount(value))
    override val succeededFindingsCount: Option[SucceededFindingsCount] = scala
      .Option(impl.succeededFindingsCount())
      .map(value => zio.aws.iot.model.primitives.SucceededFindingsCount(value))
    override val skippedFindingsCount: Option[SkippedFindingsCount] = scala
      .Option(impl.skippedFindingsCount())
      .map(value => zio.aws.iot.model.primitives.SkippedFindingsCount(value))
    override val canceledFindingsCount: Option[CanceledFindingsCount] = scala
      .Option(impl.canceledFindingsCount())
      .map(value => zio.aws.iot.model.primitives.CanceledFindingsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
  ): zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly = new Wrapper(impl)
}
