package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{TokenSignature, Token, AuthorizerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TestInvokeAuthorizerRequest(
    authorizerName: AuthorizerName,
    token: Option[Token] = None,
    tokenSignature: Option[TokenSignature] = None,
    httpContext: Option[zio.aws.iot.model.HttpContext] = None,
    mqttContext: Option[zio.aws.iot.model.MqttContext] = None,
    tlsContext: Option[zio.aws.iot.model.TlsContext] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest = {
    import TestInvokeAuthorizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest
      .builder()
      .authorizerName(AuthorizerName.unwrap(authorizerName): java.lang.String)
      .optionallyWith(
        token.map(value => Token.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        tokenSignature.map(value =>
          TokenSignature.unwrap(value): java.lang.String
        )
      )(_.tokenSignature)
      .optionallyWith(httpContext.map(value => value.buildAwsValue()))(
        _.httpContext
      )
      .optionallyWith(mqttContext.map(value => value.buildAwsValue()))(
        _.mqttContext
      )
      .optionallyWith(tlsContext.map(value => value.buildAwsValue()))(
        _.tlsContext
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TestInvokeAuthorizerRequest.ReadOnly =
    zio.aws.iot.model.TestInvokeAuthorizerRequest.wrap(buildAwsValue())
}
object TestInvokeAuthorizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TestInvokeAuthorizerRequest =
      zio.aws.iot.model.TestInvokeAuthorizerRequest(
        authorizerName,
        token.map(value => value),
        tokenSignature.map(value => value),
        httpContext.map(value => value.asEditable),
        mqttContext.map(value => value.asEditable),
        tlsContext.map(value => value.asEditable)
      )
    def authorizerName: AuthorizerName
    def token: Option[Token]
    def tokenSignature: Option[TokenSignature]
    def httpContext: Option[zio.aws.iot.model.HttpContext.ReadOnly]
    def mqttContext: Option[zio.aws.iot.model.MqttContext.ReadOnly]
    def tlsContext: Option[zio.aws.iot.model.TlsContext.ReadOnly]
    def getAuthorizerName: ZIO[Any, Nothing, AuthorizerName] =
      ZIO.succeed(authorizerName)
    def getToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("token", token)
    def getTokenSignature: ZIO[Any, AwsError, TokenSignature] =
      AwsError.unwrapOptionField("tokenSignature", tokenSignature)
    def getHttpContext
        : ZIO[Any, AwsError, zio.aws.iot.model.HttpContext.ReadOnly] =
      AwsError.unwrapOptionField("httpContext", httpContext)
    def getMqttContext
        : ZIO[Any, AwsError, zio.aws.iot.model.MqttContext.ReadOnly] =
      AwsError.unwrapOptionField("mqttContext", mqttContext)
    def getTlsContext
        : ZIO[Any, AwsError, zio.aws.iot.model.TlsContext.ReadOnly] =
      AwsError.unwrapOptionField("tlsContext", tlsContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest
  ) extends zio.aws.iot.model.TestInvokeAuthorizerRequest.ReadOnly {
    override val authorizerName: AuthorizerName =
      zio.aws.iot.model.primitives.AuthorizerName(impl.authorizerName())
    override val token: Option[Token] = scala
      .Option(impl.token())
      .map(value => zio.aws.iot.model.primitives.Token(value))
    override val tokenSignature: Option[TokenSignature] = scala
      .Option(impl.tokenSignature())
      .map(value => zio.aws.iot.model.primitives.TokenSignature(value))
    override val httpContext: Option[zio.aws.iot.model.HttpContext.ReadOnly] =
      scala
        .Option(impl.httpContext())
        .map(value => zio.aws.iot.model.HttpContext.wrap(value))
    override val mqttContext: Option[zio.aws.iot.model.MqttContext.ReadOnly] =
      scala
        .Option(impl.mqttContext())
        .map(value => zio.aws.iot.model.MqttContext.wrap(value))
    override val tlsContext: Option[zio.aws.iot.model.TlsContext.ReadOnly] =
      scala
        .Option(impl.tlsContext())
        .map(value => zio.aws.iot.model.TlsContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest
  ): zio.aws.iot.model.TestInvokeAuthorizerRequest.ReadOnly = new Wrapper(impl)
}
