package zio.aws.iot.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iot.model.primitives.{
  Seconds,
  PolicyDocument,
  PrincipalId,
  IsAuthenticated
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TestInvokeAuthorizerResponse(
    isAuthenticated: Option[IsAuthenticated] = None,
    principalId: Option[PrincipalId] = None,
    policyDocuments: Option[Iterable[PolicyDocument]] = None,
    refreshAfterInSeconds: Option[Seconds] = None,
    disconnectAfterInSeconds: Option[Seconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse = {
    import TestInvokeAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
      .builder()
      .optionallyWith(
        isAuthenticated.map(value =>
          IsAuthenticated.unwrap(value): java.lang.Boolean
        )
      )(_.isAuthenticated)
      .optionallyWith(
        principalId.map(value => PrincipalId.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        policyDocuments.map(value =>
          value.map { item =>
            PolicyDocument.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyDocuments)
      .optionallyWith(
        refreshAfterInSeconds.map(value => Seconds.unwrap(value): Integer)
      )(_.refreshAfterInSeconds)
      .optionallyWith(
        disconnectAfterInSeconds.map(value => Seconds.unwrap(value): Integer)
      )(_.disconnectAfterInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly =
    zio.aws.iot.model.TestInvokeAuthorizerResponse.wrap(buildAwsValue())
}
object TestInvokeAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TestInvokeAuthorizerResponse =
      zio.aws.iot.model.TestInvokeAuthorizerResponse(
        isAuthenticated.map(value => value),
        principalId.map(value => value),
        policyDocuments.map(value => value),
        refreshAfterInSeconds.map(value => value),
        disconnectAfterInSeconds.map(value => value)
      )
    def isAuthenticated: Option[IsAuthenticated]
    def principalId: Option[PrincipalId]
    def policyDocuments: Option[List[PolicyDocument]]
    def refreshAfterInSeconds: Option[Seconds]
    def disconnectAfterInSeconds: Option[Seconds]
    def getIsAuthenticated: ZIO[Any, AwsError, IsAuthenticated] =
      AwsError.unwrapOptionField("isAuthenticated", isAuthenticated)
    def getPrincipalId: ZIO[Any, AwsError, PrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getPolicyDocuments: ZIO[Any, AwsError, List[PolicyDocument]] =
      AwsError.unwrapOptionField("policyDocuments", policyDocuments)
    def getRefreshAfterInSeconds: ZIO[Any, AwsError, Seconds] =
      AwsError.unwrapOptionField("refreshAfterInSeconds", refreshAfterInSeconds)
    def getDisconnectAfterInSeconds: ZIO[Any, AwsError, Seconds] = AwsError
      .unwrapOptionField("disconnectAfterInSeconds", disconnectAfterInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
  ) extends zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly {
    override val isAuthenticated: Option[IsAuthenticated] = scala
      .Option(impl.isAuthenticated())
      .map(value => zio.aws.iot.model.primitives.IsAuthenticated(value))
    override val principalId: Option[PrincipalId] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.iot.model.primitives.PrincipalId(value))
    override val policyDocuments: Option[List[PolicyDocument]] = scala
      .Option(impl.policyDocuments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iot.model.primitives.PolicyDocument(item)
        }.toList
      )
    override val refreshAfterInSeconds: Option[Seconds] = scala
      .Option(impl.refreshAfterInSeconds())
      .map(value => zio.aws.iot.model.primitives.Seconds(value))
    override val disconnectAfterInSeconds: Option[Seconds] = scala
      .Option(impl.disconnectAfterInSeconds())
      .map(value => zio.aws.iot.model.primitives.Seconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse
  ): zio.aws.iot.model.TestInvokeAuthorizerResponse.ReadOnly = new Wrapper(impl)
}
