package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ServerName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TlsContext(serverName: Option[ServerName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.TlsContext = {
    import TlsContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TlsContext
      .builder()
      .optionallyWith(
        serverName.map(value => ServerName.unwrap(value): java.lang.String)
      )(_.serverName)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TlsContext.ReadOnly =
    zio.aws.iot.model.TlsContext.wrap(buildAwsValue())
}
object TlsContext {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.TlsContext] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TlsContext =
      zio.aws.iot.model.TlsContext(serverName.map(value => value))
    def serverName: Option[ServerName]
    def getServerName: ZIO[Any, AwsError, ServerName] =
      AwsError.unwrapOptionField("serverName", serverName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TlsContext
  ) extends zio.aws.iot.model.TlsContext.ReadOnly {
    override val serverName: Option[ServerName] = scala
      .Option(impl.serverName())
      .map(value => zio.aws.iot.model.primitives.ServerName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TlsContext
  ): zio.aws.iot.model.TlsContext.ReadOnly = new Wrapper(impl)
}
