package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  SQL,
  AwsIotSqlVersion,
  RuleName,
  CreatedAtDate,
  Description,
  IsDisabled
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TopicRule(
    ruleName: Option[RuleName] = None,
    sql: Option[SQL] = None,
    description: Option[Description] = None,
    createdAt: Option[CreatedAtDate] = None,
    actions: Option[Iterable[zio.aws.iot.model.Action]] = None,
    ruleDisabled: Option[IsDisabled] = None,
    awsIotSqlVersion: Option[AwsIotSqlVersion] = None,
    errorAction: Option[zio.aws.iot.model.Action] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.TopicRule = {
    import TopicRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRule
      .builder()
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(sql.map(value => SQL.unwrap(value): java.lang.String))(
        _.sql
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        createdAt.map(value => CreatedAtDate.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        ruleDisabled.map(value => IsDisabled.unwrap(value): java.lang.Boolean)
      )(_.ruleDisabled)
      .optionallyWith(
        awsIotSqlVersion.map(value =>
          AwsIotSqlVersion.unwrap(value): java.lang.String
        )
      )(_.awsIotSqlVersion)
      .optionallyWith(errorAction.map(value => value.buildAwsValue()))(
        _.errorAction
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRule.ReadOnly =
    zio.aws.iot.model.TopicRule.wrap(buildAwsValue())
}
object TopicRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.TopicRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRule = zio.aws.iot.model.TopicRule(
      ruleName.map(value => value),
      sql.map(value => value),
      description.map(value => value),
      createdAt.map(value => value),
      actions.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      ruleDisabled.map(value => value),
      awsIotSqlVersion.map(value => value),
      errorAction.map(value => value.asEditable)
    )
    def ruleName: Option[RuleName]
    def sql: Option[SQL]
    def description: Option[Description]
    def createdAt: Option[CreatedAtDate]
    def actions: Option[List[zio.aws.iot.model.Action.ReadOnly]]
    def ruleDisabled: Option[IsDisabled]
    def awsIotSqlVersion: Option[AwsIotSqlVersion]
    def errorAction: Option[zio.aws.iot.model.Action.ReadOnly]
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getSql: ZIO[Any, AwsError, SQL] = AwsError.unwrapOptionField("sql", sql)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAtDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getActions
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Action.ReadOnly]] =
      AwsError.unwrapOptionField("actions", actions)
    def getRuleDisabled: ZIO[Any, AwsError, IsDisabled] =
      AwsError.unwrapOptionField("ruleDisabled", ruleDisabled)
    def getAwsIotSqlVersion: ZIO[Any, AwsError, AwsIotSqlVersion] =
      AwsError.unwrapOptionField("awsIotSqlVersion", awsIotSqlVersion)
    def getErrorAction: ZIO[Any, AwsError, zio.aws.iot.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("errorAction", errorAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRule
  ) extends zio.aws.iot.model.TopicRule.ReadOnly {
    override val ruleName: Option[RuleName] = scala
      .Option(impl.ruleName())
      .map(value => zio.aws.iot.model.primitives.RuleName(value))
    override val sql: Option[SQL] = scala
      .Option(impl.sql())
      .map(value => zio.aws.iot.model.primitives.SQL(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iot.model.primitives.Description(value))
    override val createdAt: Option[CreatedAtDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.CreatedAtDate(value))
    override val actions: Option[List[zio.aws.iot.model.Action.ReadOnly]] =
      scala
        .Option(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Action.wrap(item)
          }.toList
        )
    override val ruleDisabled: Option[IsDisabled] = scala
      .Option(impl.ruleDisabled())
      .map(value => zio.aws.iot.model.primitives.IsDisabled(value))
    override val awsIotSqlVersion: Option[AwsIotSqlVersion] = scala
      .Option(impl.awsIotSqlVersion())
      .map(value => zio.aws.iot.model.primitives.AwsIotSqlVersion(value))
    override val errorAction: Option[zio.aws.iot.model.Action.ReadOnly] = scala
      .Option(impl.errorAction())
      .map(value => zio.aws.iot.model.Action.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRule
  ): zio.aws.iot.model.TopicRule.ReadOnly = new Wrapper(impl)
}
