package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AuthorizerArn, AuthorizerName}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateAuthorizerResponse(
    authorizerName: Option[AuthorizerName] = None,
    authorizerArn: Option[AuthorizerArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse = {
    import UpdateAuthorizerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse
      .builder()
      .optionallyWith(
        authorizerName.map(value =>
          AuthorizerName.unwrap(value): java.lang.String
        )
      )(_.authorizerName)
      .optionallyWith(
        authorizerArn.map(value =>
          AuthorizerArn.unwrap(value): java.lang.String
        )
      )(_.authorizerArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly =
    zio.aws.iot.model.UpdateAuthorizerResponse.wrap(buildAwsValue())
}
object UpdateAuthorizerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateAuthorizerResponse =
      zio.aws.iot.model.UpdateAuthorizerResponse(
        authorizerName.map(value => value),
        authorizerArn.map(value => value)
      )
    def authorizerName: Option[AuthorizerName]
    def authorizerArn: Option[AuthorizerArn]
    def getAuthorizerName: ZIO[Any, AwsError, AuthorizerName] =
      AwsError.unwrapOptionField("authorizerName", authorizerName)
    def getAuthorizerArn: ZIO[Any, AwsError, AuthorizerArn] =
      AwsError.unwrapOptionField("authorizerArn", authorizerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse
  ) extends zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly {
    override val authorizerName: Option[AuthorizerName] = scala
      .Option(impl.authorizerName())
      .map(value => zio.aws.iot.model.primitives.AuthorizerName(value))
    override val authorizerArn: Option[AuthorizerArn] = scala
      .Option(impl.authorizerArn())
      .map(value => zio.aws.iot.model.primitives.AuthorizerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse
  ): zio.aws.iot.model.UpdateAuthorizerResponse.ReadOnly = new Wrapper(impl)
}
